% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration_model.R
\name{registration_model}
\alias{registration_model}
\title{Spatial registration: model}
\usage{
registration_model(
  sce_pseudo,
  covars = NULL,
  var_registration = "registration_variable"
)
}
\arguments{
\item{sce_pseudo}{The output of \code{registration_pseudobulk()}.}

\item{covars}{A \code{character()} with names of sample-level covariates.}

\item{var_registration}{A \code{character(1)} specifying the \code{colData(sce_pseudo)}
variable of interest against which will be used for computing the relevant
statistics.}
}
\value{
The output of \code{model.matrix()} which you can inspect to verify that
your sample-level covariates are being properly modeled.
}
\description{
This function defines the statistical model that will be used for computing
the block correlation as well as pairwise statistics. It is useful to check
it in case your sample-level covariates need to be casted. For example, an
\code{integer()} variable might have to be casted into a \code{factor()} if you wish
to model it as a categorical variable and not a continuous one.
}
\examples{
example("registration_pseudobulk", package = "spatialLIBD")
registration_mod <- registration_model(sce_pseudo, "age")
head(registration_mod)

}
\seealso{
Other spatial registration and statistical modeling functions: 
\code{\link{registration_block_cor}()},
\code{\link{registration_pseudobulk}()},
\code{\link{registration_stats_anova}()},
\code{\link{registration_stats_enrichment}()},
\code{\link{registration_stats_pairwise}()},
\code{\link{registration_wrapper}()}
}
\concept{spatial registration and statistical modeling functions}
