% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colors.R
\name{get_colors}
\alias{get_colors}
\title{Obtain the colors for a set of cluster names}
\usage{
get_colors(colors = NULL, clusters)
}
\arguments{
\item{colors}{A vector of colors. If \code{NULL} then a set of default colors will
be used when \code{clusters} has less than 12 unique values, otherwise
\code{Polychrome::palette36} will be used which can
generate up to 36 unique colors. If the number of unique clusters is beyond
36 then this function will fail.}

\item{clusters}{A vector of cluster names.}
}
\value{
A named vector where the values are the colors to use for
displaying them different clusters. For some use cases, you might have to
either change the names or use \link[base:unname]{unname()}.
}
\description{
This function returns a vector of colors based on a vector of cluster
names. It can be used to automatically assign colors.
}
\examples{

## Obtain the necessary data
if (!exists("sce_layer")) sce_layer <- fetch_data("sce_layer")

## Example layer colors with the corresponding names
get_colors(libd_layer_colors, sce_layer$layer_guess)
get_colors(libd_layer_colors, sce_layer$layer_guess_reordered_short)

## Example where colors are assigned automatically
## based on a pre-defined set of colors
get_colors(clusters = sce_layer$kmeans_k7)

## Example where Polychrome::palette36.colors() gets used
get_colors(clusters = letters[seq_len(13)])

## What happens if you have a logical variable with NAs?
set.seed(20240712)
log_var <- sample(c(TRUE, FALSE, NA),
    1000,
    replace = TRUE,
    prob = c(0.3, 0.15, 0.55)
)
log_var_sorted <- sort_clusters(log_var)
get_colors(colors = NULL, clusters = log_var_sorted)
}
