## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly=TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("scaeData")

## ----eval=FALSE---------------------------------------------------------------
# if (!require("devtools", quietly = TRUE))
#     install.packages("devtools")
# 
# devtools::install_github("AGImkeller/scaeData", build_vignettes = TRUE)

## ----libraries, include=TRUE--------------------------------------------------
library("scaeData")

## ----eval = FALSE-------------------------------------------------------------
# pbmc_5k <- scaeDataGet("pbmc_5k")
# pbmc_10k <- scaeDataGet("pbmc_10k")

## -----------------------------------------------------------------------------
pbmc_20k <- scaeDataGet("pbmc_20k")

pbmc_20k

## -----------------------------------------------------------------------------
cells.dir <- file.path(pbmc_20k$dir, pbmc_20k$barcodes)
features.dir <- file.path(pbmc_20k$dir, pbmc_20k$features)
mat.dir <- file.path(pbmc_20k$dir, pbmc_20k$matrix)

cells <- utils::read.csv(cells.dir, sep = "", header = FALSE)
features <- utils::read.delim(features.dir, header = FALSE)
mat <- Matrix::readMM(mat.dir)

rownames(mat) <- cells$V1
colnames(mat) <- features$V1
head(mat)

## -----------------------------------------------------------------------------
lookup <- read.csv(system.file("extdata", "pbmc_20k_lookup_table.csv", package="scaeData"))

library("SingleCellAlleleExperiment")
scae_20k <- read_allele_counts(pbmc_20k$dir,
                               sample_names = "example_data",
                               filter_mode = "no",
                               lookup_file = lookup,
                               barcode_file = pbmc_20k$barcodes,
                               gene_file = pbmc_20k$features,
                               matrix_file = pbmc_20k$matrix,
                               verbose = TRUE)

scae_20k

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

