% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoeckiusHashingData.R
\name{StoeckiusHashingData}
\alias{StoeckiusHashingData}
\title{Obtain the Stoeckius cell hashing data}
\usage{
StoeckiusHashingData(
  type = c("pbmc", "mixed"),
  mode = NULL,
  ensembl = FALSE,
  location = TRUE,
  strip.metrics = TRUE,
  legacy = FALSE
)
}
\arguments{
\item{type}{String specifying the dataset to obtain.}

\item{mode}{String specifying the data modalities to obtain, see Details.}

\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{strip.metrics}{Logical scalar indicating whether quality control metrics should be removed from the HTO/ADT counts.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a matrix of UMI counts corresponding to the first \code{mode},
plus any number of alternative Experiments containing the remaining \code{mode}s.
If multiple \code{mode}s are specified, the output object only contains the intersection of their column names.
}
\description{
Obtain the (mostly human) cell hashing single-cell RNA-seq data from Stoeckius et al. (2018).
}
\details{
When \code{type="pbmc"}, the \code{mode} can be one or more of:
\itemize{
\item \code{"human"}, the RNA counts for human genes.
\item \code{"mouse"}, the RNA counts for mouse genes.
Present as the PBMC dataset is actually a mixture of human PBMCs and unlabelled mouse cells.
\item \code{"hto"}, the HTO counts.
\item \code{"adt1"}, counts for the first set of ADTs (immunoglobulin controls).
\item \code{"adt2"}, counts for the second set of ADTs (cell type-specific markers).
}
If \code{mode=NULL}, the default is to use \code{"human"}, \code{"mouse"} and \code{"hto"}.

When \code{type="mixed"}, the \code{mode} can be one or more of:
\itemize{
\item \code{"rna"}, the RNA counts for the genes;
\item \code{"hto"}, the HTO counts.
}
If \code{mode=NULL}, the default is to use \code{"rna"} and \code{"hto"}.

If \code{ensembl=TRUE}, gene symbols for the RNA counts are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE} and only for the RNA counts.

For the HTO and ADT matrices, some rows correspond to quality control metrics.
If \code{strip.metrics=TRUE}, these rows are removed so that only data for actual HTOs or ADTs are present.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/nestorowa-hsc}.
}
\examples{
sce.pbmc <- StoeckiusHashingData()
sce.pbmc

sce.mixed <- StoeckiusHashingData(type="mixed")
sce.mixed

}
\references{
Stoeckius et al. (2018). 
Cell Hashing with barcoded antibodies enables multiplexing and doublet detection for single cell genomics.
\emph{Genome Biol.} 19, 224.
}
\author{
Aaron Lun
}
