% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShekharRetinaData.R
\name{ShekharRetinaData}
\alias{ShekharRetinaData}
\title{Obtain the Shekhar retina data}
\usage{
ShekharRetinaData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the mouse retina single-cell RNA-seq dataset from Shekhar et al. (2016).
}
\details{
Column metadata contains the cluster identities as reported in the paper.
Note that some cells will have \code{NA} identities as they are present in the count matrix but not in the metadata file.
These are presumably low-quality cells that were discarded prior to clustering.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/shekhar-retina}.
}
\examples{
sce <- ShekharRetinaData()

}
\references{
Shekhar K et al. (2016). 
Comprehensive classification of retinal bipolar neurons by single-cell transcriptomics.
\emph{Cell} 166(5), 1308-1323.
}
\author{
Aaron Lun
}
