% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChenBrainData.R
\name{ChenBrainData}
\alias{ChenBrainData}
\title{Obtain the Chen brain data}
\usage{
ChenBrainData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the mouse brain single-cell RNA-seq data from Chen et al. (2017).
}
\details{
Column metadata is provided in the same form as supplied in GSE87544.
This contains the putative cell type assigned by the original authors.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/chen-brain}.
}
\examples{
sce <- ChenBrainData()

}
\references{
Chen R et al. (2017).
Single-Cell RNA-Seq reveals hypothalamic cell diversity. 
\emph{Cell Rep.} 18, 3227-3241.
}
\author{
Aaron Lun
}
