% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertHDF5.R
\name{assertHDF5}
\alias{assertHDF5}
\title{check if a file is a valid HDF5 file}
\usage{
assertHDF5(path)
}
\arguments{
\item{path}{path to file to test}
}
\value{
Returns invisible \code{path} if check is successful, otherwise signals an error.
}
\description{
Check if a file path argument points to an non-corrupt HDF5 file.
}
\details{
Compares the first 8 bytes of a file to those of the standard HDF5 file header.
}
\section{Further development}{

The HDF5 file header contains 8 bytes, which hold specific meanings.
Currently the function only tests that the header of the file
specified by \code{path} is identical to a healthy HDF5 file and signals
a general error if that is not the case.
Reporting specific types of corruption can be implemented.
}

\examples{
fileName1 <- tempfile(fileext = ".h5")
rhdf5::h5createFile(fileName1)
rhdf5::h5write(mtcars, fileName1, "mtcars")
rhdf5::h5closeAll()
fileName2 <-  tempfile(fileext = ".csv")
write.csv(mtcars, fileName2)

assertHDF5(fileName1)   # passes
\dontrun{
assertHDF5(fileName2)   # fails
}

}
\references{
\url{http://web.ics.purdue.edu/~aai/HDF5/html/H5.format.html#BootBlock}
}
\author{
Aleksander Chlebowski
}
