% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{IMR90_DNAloops_pairs}
\alias{IMR90_DNAloops_pairs}
\title{plotgardener example DNA loop pair data}
\format{
a dataframe in BEDPE (paired ranges) format
\describe{
\item{chrom1}{The name of the chromosome on which the first
end of the feature exists.}
\item{start1}{The starting position of the first end of the
feature on chrom1.}
\item{end1}{The ending position of the first end of the
feature on chrom1.}
\item{chrom2}{The name of  the chromosome on which the
second end of the feature exists.}
\item{start2}{The starting position of the second end of
the feature on chrom2.}
\item{end2}{The ending position of the second end of the
feature on chrom2.}
}
}
\usage{
data("IMR90_DNAloops_pairs")
}
\description{
A dataset listing interaction data along genomic coordinates
in the region chr21:28000000-30300000 according to the hg19 genome build.
This data represents called DNA loops in the IMR90 cell line.
}
\references{
Rao SS, Huntley MH, Durand NC, Stamenova EK, Bochkov ID,
Robinson JT, Sanborn AL, Machol I, Omer AD, Lander ES, Aiden EL.
A 3D map of the human genome at kilobase resolution reveals principles
of chromatin looping. Cell.
2014 Dec 18;159(7):1665-80. doi: 10.1016/j.cell.2014.11.021.
Epub 2014 Dec 11. Erratum in: Cell. 2015 Jul 30;162(3):687-8.
PMID: 25497547; PMCID: PMC5635824.
(\href{https://pubmed.ncbi.nlm.nih.gov/25497547/}{PubMed})
}
\keyword{datasets}
