% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadOrthosData.R
\name{GetorthosModels}
\alias{GetorthosModels}
\title{Cache orthosData models}
\usage{
GetorthosModels(
  organism = c("Human", "Mouse"),
  ARCHS4v = "v212",
  verbose = TRUE
)
}
\arguments{
\item{organism}{Character scalar selecting the organism for which to load the
contrast database. One of \code{"Human"} or \code{"Mouse"}.}

\item{ARCHS4v}{Version of ARCHS4 used to build the contrastDB.}

\item{verbose}{Logical scalar indicating whether to print messages along
the way.}
}
\value{
A character vector with the full paths to the cached models
}
\description{
Download in cache a set of orthosData keras models from ExperimentHub.
}
\details{
The function pre-caches a set of pre-trained orthosData keras models for a
given organism.
These are the models required to perform inference in `orthos`.
For each organism they are of three types:

\strong{ContextEncoder}: The encoder component of a Variational Autoencoder
(VAE). Used to  produce a latent encoding of a given gene expression profile
(i.e context).

- Input is a gene expression vector (shape=N, where N is the number or
`orthos` gene features) in the form of log2-transformed library normalized
counts (log2 counts per million, log2CPMs).

- Output is a 64-d latent representation of the context.

\strong{DeltaEncoder}: The encoder component of a conditional Variational
Autoencoder (cVAE).

Used to produce a latent encoding of a contrast between two conditions (i.e
delta).

- Input is a vector of gene expression contrasts (shape=N) in the form of
gene log2 CPM ratios (log2 fold changes, log2FCs),
concatenated with the corresponding context encoding.

- Output is a 512-d latent representation of the contrast, conditioned on
the context.

\strong{DeltaDecoder}: The decoder component of the same cVAE as above.
Used to produce the decoded version of the contrast between two conditions.

- Input is the concatenated vector of the delta and context latent encodings.

- Output is the decoded contrast vector (shape=N), conditioned on the context.

For more details on model architecture and use of these models in `orthos`
please refer to the `orthos` package vignette:
vignette("orthosIntro", package = "orthos").
}
\examples{
GetorthosModels(organism = "Mouse")

}
\author{
Panagiotis Papasaikas
}
