% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildDatabase.R
\name{buildDatabase}
\alias{buildDatabase}
\title{buildDatabase}
\usage{
buildDatabase(dataset_names, population_ids)
}
\arguments{
\item{dataset_names}{A vector of strings with the names of the cytometries, ranging in c("Cytometry1",...,"Cytometry40").}

\item{population_ids}{A vector of strings with the names of the cell types to be selected in each cytometry.}
}
\value{
A list where each element is a cytometry containing only the cell types given by population_ids.
}
\description{
Constructs a subset of the cell types and cytometries in optimalFlowData in order to be used as a database.
}
\examples{
database <- buildDatabase(
  dataset_names = paste0('Cytometry', c(2:5, 7:9, 12:17, 19, 21)),
  population_ids = c('Monocytes', 'CD4+CD8-', 'Mature SIg Kappa', 'TCRgd-'))

}
