
<!-- README.md is generated from README.Rmd. Please edit that file -->
Data and citation
=================

The `nanotubes` packages contains CAGE data from the paper "Identification of Gene Transcription Start Sites and Enhancers Responding to Pulmonary Carbon Nanotube Exposure in Vivo" (<https://pubs.acs.org/doi/abs/10.1021/acsnano.6b07533>). Data is provided as CAGE Transcription Start Sites (CTSSs) stored as BigWig-files, along with the study design.

If you use nanotubes, please cite the following article:

``` r
citation("nanotubes")
#> 
#>   Bornholdt et al. Identification of Gene Transcription Start
#>   Sites and Enhancers Responding to Pulmonary Carbon Nanotube
#>   Exposure in Vivo, ACS Nano (2017)
#> 
#> A BibTeX entry for LaTeX users is
#> 
#>   @Article{,
#>     title = {Identification of Gene Transcription Start Sites and Enhancers Responding to Pulmonary Carbon Nanotube Exposure in Vivo},
#>     author = {Jette Bornholdt and Anne Thoustrup Saber and Berit Lilje and Mette Boyd and Mette Jørgensen and Yun Chen and Morana Vitezic and Nicklas Raun Jacobsen and Sarah Søs Poulsen and Trine Berthing and Simon Bressendorff and Kristoffer Vitting-Seerup and Robin Andersson and Karin Sørig Hougaard and Carole L. Yauk and Sabina Halappanavar and Håkan Wallin and Ulla Vogel and Albin Sandelin},
#>     year = {2017},
#>     journal = {ACS Nano},
#>     doi = {10.1021/acsnano.6b07533},
#>     volume = {11},
#>     number = {4},
#>     pages = {3597-3613},
#>   }
```

Installation
============

You can install the development version directly from GitHub using `devtools`:

``` r
devtools::install_github("MalteThodberg/nanotubes")
```
