#' Standard Samples for CellScore [hgu133plus2]
#'
#' This ExpressionSet object contains the expression values, expression calls,
#' phenoData, and array annotation data for the standard samples from Affymetrix
#' hgu133plus2 microarrays. The dataset is meant for usage with the package
#' CellScore. This set of manually curated data contains reference expression
#' data for normal tissues or cell types. Details of how this dataset was
#' generated can be found in the vignette.
#'
#' @name hgu133plus2CellScore
#'
#' @docType data
#'
#' @usage eset.std
#'
#' @format an ExpressionSet object
#'
#' @keywords dataset cellscore
#'
#' @import Biobase
#'
#' @source data extracted from public databases such as Gene Expression Omnibus 
#' (https://www.ncbi.nlm.nih.gov/geo/) or  ArrayExpress 
#' (https://www.ebi.ac.uk/arrayexpress/)
"eset.std"
