% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourDNData.R
\name{fourDNData}
\alias{fourDNData}
\alias{fourDNHiCExperiment}
\title{fourDNData}
\arguments{
\item{experimentSetAccession}{Any 4DN-provided experimentSet Accession number
(check https://data.4dnucleome.org/browse/) for a browser-based
explorer.}

\item{type}{any of c('pairs', 'hic', 'mcool', 'boundaries',
'insulation', 'compartments')}

\item{.fetch_pairs}{Whether to also download the associated pairs file}
}
\value{
\code{fourDNData()} returns the local path of the queried file
cached with BiocFileCache. \code{fourDNHiCExperiment()} returns a
\code{HiCExperiment} object with populated metadata and topologicalFeatures (
if available).
}
\description{
Fetches files from the 4DN data portal and caches them using
the BiocFileCache system.
}
\examples{
####################################
## Importing individual 4DN files ##
####################################

head(fourDNData())
mcf <- fourDNData(experimentSetAccession = '4DNESDP9ECMN', type = 'mcool')
mcf

####################################
## Importing full 4DN experiments ##
####################################

id <- fourDNData() |>
  dplyr::filter(
     experimentType == 'in situ Hi-C', 
     biosource == 'GM12878', 
     publication == 'Sanborn AL et al. (2015)'
  ) |> 
  dplyr::arrange(size) |> 
  dplyr::pull(experimentSetAccession) |> 
  unique()
id[1]
x <- fourDNHiCExperiment(id[1])
x
HiCExperiment::topologicalFeatures(x)
S4Vectors::metadata(x)$`4DN_info`
}
