% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_summary.R
\docType{data}
\name{gene_summary}
\alias{gene_summary}
\alias{gene_summary_22Q1}
\alias{depmap_gene_summary}
\title{gene_summary_22Q1}
\format{
A data frame with 69746 rows (cell lines) and 7 variables:
\describe{
    \item{entrez_id}{Entrez ID# (e.g. 100316904)}
    \item{gene_name}{HUGO symbol (e.g. "SAP25")}
    \item{dataset}{which dataset this probability derives}
    \item{dependent_cell_lines}{number of dependent cell lines}
    \item{cell_lines_with_data}{number of cell lines with relevant dependency
     data}
    \item{strongly_selective}{Gene knockout is selective (not pan-lethal)}
    \item{common_essential}{common essential gene dependency}
}
}
\source{
DepMap, Broad Institute: https://depmap.org/portal/download/
}
\usage{
gene_summary
}
\description{
The `gene_summary` dataset contains the 22Q1 gene essentiality
probabilities for select genes. This dataset can be loaded into the R
environment with the `depmap_gene_summary` function.
}
\details{
This data represents the `Gene Dependency Profile Summary.csv` file
taken from the 22Q1
[Broad Institute](https://depmap.org/portal/api/download/gene_dep_summary)
release.
}
\section{Change log}{


- 22Q1: Initial dataset

- 22Q2: no change, no further releases are scheduled at this time.
}

\examples{
\dontrun{
depmap_gene_summary()
}

}
\references{
Tsherniak, A., Vazquez, F., Montgomery, P. G., Weir, B. A.,
Kryukov, G., Cowley, G. S., ... & Meyers, R. M. (2017). Defining a cancer
dependency map. Cell, 170(3), 564-576.

James M. McFarland, Zandra V. Ho, Guillaume Kugener, Joshua M. Dempster,
Phillip G. Montgomery, Jordan G. Bryan, John M. Krill-Burger, Thomas M.
Green, Francisca Vazquez, Jesse S. Boehm, Todd R. Golub, William C. Hahn,
David E. Root, Aviad Tsherniak. (2018). Improved estimation of cancer
dependencies from large-scale RNAi screens using model-based normalization
and data integration. Nature Communications 9, 1.
}
\keyword{datasets}
