% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatabaseImmuneExpressionData.R
\name{DatabaseImmuneCellExpressionData}
\alias{DatabaseImmuneCellExpressionData}
\title{Obtain human bulk RNA-seq data from DICE}
\usage{
DatabaseImmuneCellExpressionData(
  ensembl = FALSE,
  cell.ont = c("all", "nonna", "none"),
  legacy = FALSE
)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether to convert row names to Ensembl IDs.
Genes without a mapping to a non-duplicated Ensembl ID are discarded.}

\item{cell.ont}{String specifying whether Cell Ontology terms should be included in the \code{\link{colData}}.
If \code{"nonna"}, all samples without a valid term are discarded;
if \code{"all"}, all samples are returned with (possibly \code{NA}) terms;
if \code{"none"}, terms are not added.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SummarizedExperiment} object with a \code{"logcounts"} assay
containing the log-normalized expression values, along with cell type labels in the 
\code{\link{colData}}.
}
\description{
Download and cache the normalized expression values of 1561 bulk RNA-seq samples
of sorted cell populations from the Database of Immune Cell Expression (DICE).
}
\details{
This function provides normalized expression values of 1561 bulk RNA-seq samples
generated by DICE from pure populations of human immune cells.

TPM normalized values for each cell type were downloaded from \url{https://dice-database.org/downloads}. 
Genes with no reads across samples were removed, and values were log2 normalized after a pseudocount of 1 was added.

The dataset contains 1561 human RNA-seq samples annotated to 5 main cell types (\code{"label.main"}):
\itemize{
    \item B cells
    \item Monocytes
    \item NK cells
    \item T cells, CD8+
    \item T cells, CD4+
}

Samples were additionally annotated to 15 fine cell types (\code{"label.fine"}):
\itemize{
    \item B cells, naive
    \item Monocytes, CD14+
    \item Monocytes, CD16+
    \item NK cells
    \item T cells, memory TREG
    \item T cells, CD4+, naive
    \item T cells, CD4+, naive, stimulated
    \item T cells, CD4+, naive Treg
    \item T cells, CD4+, Th1
    \item T cells, CD4+, Th1_17
    \item T cells, CD4+, Th2
    \item T cells, CD8+, naïve
    \item T cells, CD8+, naïve, stimulated
    \item T cells, CD4+, TFH
    \item T cells, CD4+, Th17
}
The subtypes have also been mapped to the Cell Ontology (\code{"label.ont"},
if \code{cell.ont} is not \code{"none"}), which can be used for further programmatic
queries.
}
\examples{
ref.se <- DatabaseImmuneCellExpressionData()

}
\references{
Schmiedel B et al. (2018).
Impact of Genetic Polymorphisms on Human Immune Cell Gene Expression.
\emph{Cell} 175, 1701-1715.
}
\author{
Jared Andrews
}
