% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bugphyzz.R
\name{makeSignatures}
\alias{makeSignatures}
\title{Make signatures}
\usage{
makeSignatures(
  dat,
  taxIdType = c("NCBI_ID", "Taxon_name"),
  taxLevel = c("mixed", "superkingdom", "phylum", "class", "order", "family", "genus",
    "species", "strain"),
  evidence = c("exp", "igc", "tas", "nas", "tax", "asr"),
  frequency = c("always", "usually", "sometimes", "unknown"),
  minSize = 10,
  min = NULL,
  max = NULL
)
}
\arguments{
\item{dat}{A data.frame.}

\item{taxIdType}{A character string. Valid options: NCBI_ID, Taxon_name.}

\item{taxLevel}{A character vector. Taxonomic rank. Valid options:
superkingdom, kingdom, phylum, class, order, family, genus, species, strain.
They can be combined. "mixed" is equivalent to select all valid ranks.}

\item{evidence}{A character vector. Valid options: exp, igc, nas, tas, tax,
asr. They can be combined. Default is all.}

\item{frequency}{A character vector. Valid options: always, usually,
sometimes, rarely, unknown. They can be combined. By default, "rarely" is
excluded.}

\item{minSize}{Minimum number of bugs in a signature. Default is 10.}

\item{min}{Minimum value (inclusive). Only for numeric attributes.
Default is NULL.}

\item{max}{Maximum value (inclusive). Only for numeric attributes.
Default is NULL.}
}
\value{
A list of character vectors with scientific names or taxids.
}
\description{
\code{makeSignatures} Creates signatures for a list of bug signatures from
a tidy data.frame imported through the \code{importBugphyzz} function. Please
run \code{browseVignettes("bugphyz")} for detailed examples.
}
\examples{

bp <- importBugphyzz()
sigs <- purrr::map(bp, makeSignatures)
sigs <- purrr::list_flatten(sigs, name_spec = "{inner}")

}
