% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TabulaMurisSenisDroplet.R
\name{TabulaMurisSenisDroplet}
\alias{TabulaMurisSenisDroplet}
\title{Access the Tabula Muris Senis droplet single-cell RNA-seq data}
\usage{
TabulaMurisSenisDroplet(
  tissues = "All",
  processedCounts = FALSE,
  reducedDims = TRUE,
  infoOnly = FALSE
)
}
\arguments{
\item{tissues}{A character vector with the tissues to retrieve objects for.
A list of available tissues can be obtained using
\code{listTabulaMurisSenisTissues("Droplet")}.}

\item{processedCounts}{Logical scalar. If \code{TRUE}, include the processed
counts in addition to the raw counts in the SingleCellExperiment object.}

\item{reducedDims}{Logical scalar. If \code{TRUE}, include the PCA, tSNE
and UMAP representations in the SingleCellExperiment object (the tSNE
representation is not available for the full dataset ('All' tissue)).}

\item{infoOnly}{Logical scalar. If \code{TRUE}, only print the total size
of the files that will be downloaded to and/or retrieved from the cache.}
}
\value{
If \code{infoOnly} is \code{FALSE}, returns a named list of
  \code{\link[SingleCellExperiment:SingleCellExperiment-class]{SingleCellExperiment}}
  objects (one per tissue requested
  via \code{tissues}). Otherwise, each element in the list is `NULL`.
}
\description{
Access the droplet (10x Genomics) RNA-seq data from the Tabula Muris Senis
consortium.
}
\details{
The data set was downloaded from figshare
(https://figshare.com/articles/dataset/Processed_files_to_use_with_scanpy_/8273102?file=23938934
for the full data set,
https://figshare.com/articles/dataset/Tabula_Muris_Senis_Data_Objects/12654728
for the individual tissue ones).
}
\examples{
if (interactive()) {
  sce <- TabulaMurisSenisDroplet(tissues = "All")
}

}
\references{
Schaum et al (2019): The murine transcriptome reveals global aging nodes with
organ-specific phase and amplitude. bioRxiv doi:10.1101/662254.

The Tabula Muris Consortium (2020): A single-cell transcriptomic atlas
characterizes ageing tissues in the mouse. Nature 583:590–595.
}
\author{
Charlotte Soneson
}
