% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryTME.R
\name{queryTME}
\alias{queryTME}
\title{A function to query TME datasets available in this package}
\usage{
queryTME(
  geo_accession = NULL,
  score_type = NULL,
  has_signatures = NULL,
  has_truth = NULL,
  tumour_type = NULL,
  author = NULL,
  journal = NULL,
  year = NULL,
  pmid = NULL,
  sequence_tech = NULL,
  organism = NULL,
  metadata_only = FALSE,
  sparse = FALSE
)
}
\arguments{
\item{geo_accession}{Search by geo accession number. Good for returning individual datasets}

\item{score_type}{Search by type of score (TPM, FPKM, raw count)}

\item{has_signatures}{Return only those datasets that have cell-type gene signatures available, or only those without (TRUE/FALSE)}

\item{has_truth}{Return only those datasets that have cell-type annotations available, or only those without annotations}

\item{tumour_type}{Search by type of tumour represented by the dataset}

\item{author}{Search by the author who published the dataset}

\item{journal}{Search by the journal the dataset was published in.}

\item{year}{Search by exact year or year ranges with '<', '>', or '-'. For example, you can return datasets newer than 2013 with '>2013'}

\item{pmid}{Search by Pubmed ID associated with the study. Good for returning individual datasets}

\item{sequence_tech}{Search by sequencing technology used to sample the cells.}

\item{organism}{Search by source organism used in the study, for example human or mouse.}

\item{metadata_only}{Return rows of metadata instead of actual datasets. Useful for exploring what data is available without actually downloading data. Defaults to FALSE}

\item{sparse}{Return expression as a sparse matrix.
Uses less memory but is less convenient to view, recommended only if encounter memory issues with dense data. Defaults to FALSE.}
}
\value{
A list containing a table of metadata or
one or more SingleCellExperiment objects
}
\description{
This function allows you to search and subset included TME datasets.
A list of tme_data objects matching the provided options will be returned,
if queryTME is called without any options it will retrieve all available datasets.
This should only be done on machines with a large amount of ram (>64gb) because some datasets are quite large.
In most cases it is recommended to instead filter databases with some criteria.
}
\examples{

## Retrieve the metadata table to see what data is available
res <- queryTME(metadata_only = TRUE)

## Retrieve a filtered metadata table that only shows datasets with 
## cell type annotations and cell type gene signatures
res <- queryTME(has_truth = TRUE, has_signatures = TRUE, metadata_only = TRUE)

## Retrieve a single dataset identified from the table
res <- queryTME(geo_accession = "GSE72056")
}
\keyword{tumour}
