meta <- data.frame(Title = c("100 1:1 Mixture of Fresh Frozen Human (HEK293T) and Mouse (NIH3T3) Cells",
                             "1k 1:1 Mixture of Fresh Frozen Human (HEK293T) and Mouse (NIH3T3) Cells (v3 chemistry)",
                             "1k PBMCs from a Healthy Donor (v3 chemistry)",
                             "10k Brain Cells from an E18 Mouse (v3 chemistry)"),
                   Description = "",
                   BiocVersion = "3.11",
                   Genome = c("GRCh38.p12", "GRCh38.p12", "GRCh38.p12",
                              "GRCm38.p6"),
                   SourceType = "FASTQ",
                   SourceUrl = c("http://cf.10xgenomics.com/samples/cell-exp/2.1.0/hgmm_100/hgmm_100_fastqs.tar",
                                 "http://cf.10xgenomics.com/samples/cell-exp/3.0.0/hgmm_1k_v3/hgmm_1k_v3_fastqs.tar",
                                 "http://cf.10xgenomics.com/samples/cell-exp/3.0.0/pbmc_1k_v3/pbmc_1k_v3_fastqs.tar",
                                 "http://s3-us-west-2.amazonaws.com/10x.files/samples/cell-exp/3.0.0/neuron_10k_v3/neuron_10k_v3_fastqs.tar"),
                   SourceVersion = c("2017-11-08", rep("2018-11-19", 3)),
                   Species = c(rep("Homo sapiens", 3), "Mus musculus"),
                   TaxonomyId = c(rep("9606", 3), "10090"),
                   Coordinate_1_based = FALSE,
                   DataProvider = c(rep("10x", 4)),
                   Maintainer = "Lambda Moses <dlu2@caltech.edu>",
                   RDataClass = "dgCMatrix",
                   DispatchClass = "FilePath",
                   RDataPath = paste0("TENxBUSData/v1.2/",
                                      c("hgmm100.tar.gz", "hgmm1k.tar.gz",
                                        "pbmc1k.tar.gz", "neuron10k.tar.gz")),
                   stringsAsFactors = FALSE)
meta$Description <- meta$Title
write.csv(meta, "./inst/extdata/metadata.csv", row.names = FALSE)
