% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{exampleTENETClinicalDataFrame}
\alias{exampleTENETClinicalDataFrame}
\title{Example TENET clinical data frame}
\usage{
exampleTENETClinicalDataFrame(metadata = FALSE)
}
\arguments{
\item{metadata}{If TRUE, retrieve the ExperimentHub metadata instead of the
object itself. Defaults to FALSE.}
}
\value{
A data frame with 231 rows and 43 variables.
\describe{
\item{\code{vital_status}}{(character) Contains vital status data for each
sample, listed as either "Alive", "Dead", or NA. Values are derived
directly from the TCGA patient data.
}
\item{\code{time}}{(double) Contains survival time values, in days, for
each sample. Values are derived directly from the TCGA patient data.
}
\item{\code{purity}}{(double) Contains simulated purity data for each
sample, ranging from 0 to 1.
}
\item{\code{ENSG00000165821_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000165821 (SALL2) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000165821_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000165821 (SALL2) gene, either 0 or 1.
}
\item{\code{ENSG00000169989_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000169989 (TIGD4) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000169989_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000169989 (TIGD4) gene, either 0 or 1.
}
\item{\code{ENSG00000197343_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000197343 (ZNF655) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000197343_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000197343 (ZNF655) gene, either 0 or 1.
}
\item{\code{ENSG00000169083_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000169083 (AR) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000169083_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000169083 (AR) gene, either 0 or 1.
}
\item{\code{ENSG00000177842_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000177842 (ZNF620) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000177842_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000177842 (ZNF620) gene, either 0 or 1.
}
\item{\code{ENSG00000234284_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000234284 (ZNF879) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000234284_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000234284 (ZNF879) gene, either 0 or 1.
}
\item{\code{ENSG00000177853_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000177853 (ZNF518A) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000177853_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000177853 (ZNF518A) gene, either 0 or 1.
}
\item{\code{ENSG00000196345_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000196345 (ZKSCAN7) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000196345_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000196345 (ZKSCAN7) gene, either 0 or 1.
}
\item{\code{ENSG00000196653_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000196653 (ZNF502) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000196653_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000196653 (ZNF502) gene, either 0 or 1.
}
\item{\code{ENSG00000162599_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000162599 (NFIA) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000162599_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000162599 (NFIA) gene, either 0 or 1.
}
\item{\code{ENSG00000129514_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000129514 (FOXA1) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000129514_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000129514 (FOXA1) gene, either 0 or 1.
}
\item{\code{ENSG00000124664_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000124664 (SPDEF) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000124664_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000124664 (SPDEF) gene, either 0 or 1.
}
\item{\code{ENSG00000107485_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000107485 (GATA3) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000107485_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000107485 (GATA3) gene, either 0 or 1.
}
\item{\code{ENSG00000091831_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000091831 (ESR1) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000091831_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000091831 (ESR1) gene, either 0 or 1.
}
\item{\code{ENSG00000118513_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000118513 (MYB) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000118513_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000118513 (MYB) gene, either 0 or 1.
}
\item{\code{ENSG00000100219_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000100219 (XBP1) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000100219_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000100219 (XBP1) gene, either 0 or 1.
}
\item{\code{ENSG00000152192_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000152192 (POU4F1) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000152192_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000152192 (POU4F1) gene, either 0 or 1.
}
\item{\code{ENSG00000105261_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000105261 (OVOL3) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000105261_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000105261 (OVOL3) gene, either 0 or 1.
}
\item{\code{ENSG00000178935_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000178935 (ZNF552) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000178935_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000178935 (ZNF552) gene, either 0 or 1.
}
\item{\code{ENSG00000115163_CNV}}{
(integer) Contains simulated CNV data for each sample for the
ENSG00000115163 (CENPA) gene, ranging from -2 to 2.
}
\item{\code{ENSG00000115163_SM}}{
(integer) Contains simulated SM data for each sample for the
ENSG00000115163 (CENPA) gene, either 0 or 1.
}
}
}
\description{
A data frame containing example and simulated clinical
information corresponding to the samples in the
\code{exampleTENETMultiAssayExperiment} object, used to demonstrate how TENET
functions can import clinical data from a specified data frame. Clinical
data are utilized by the \code{step2GetDifferentiallyMethylatedSites},
\code{step7TopGenesSurvival}, and \code{step7ExpressionVsDNAMethylationScatterplots}
functions. The data frame consists of vital status and time variables for
use by the \code{step7TopGenesSurvival} function, simulated purity data for each
sample, and simulated copy number variation (CNV) and somatic mutation (SM)
data for the top 10 genes by number of linked hypermethylated and
hypomethylated probes derived from analyses done using the
\code{exampleTENETMultiAssayExperiment} object. These data are a subset of the
clinical data contained in the colData of the
\code{exampleTENETMultiAssayExperiment} object.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
exampleTENETClinicalDataFrame()
\dontshow{\}) # examplesIf}
}
