% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCellMultiModal.R
\name{SingleCellMultiModal}
\alias{SingleCellMultiModal}
\title{Combining Modalities into one MultiAssayExperiment}
\usage{
SingleCellMultiModal(
  DataTypes,
  modes = "*",
  versions = "1.0.0",
  dry.run = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{DataTypes}{\code{character()} A vector of data types as indicated in each
individual function by the \code{DataType} parameter. These can be any of
the following: "mouse_gastrulation", "pbmc_10x",
"macrophage_differentiation", "cord_blood", "peripheral_blood",
"mouse_visual_cortex", "mouse_embryo_8_cell"}

\item{modes}{list() A list or CharacterList of modes for each data type
where each element corresponds to one data type.}

\item{versions}{\code{character()} A vector of versions for each DataType. By
default, version \verb{1.0.0} is obtained for all data types.}

\item{dry.run}{\code{logical(1)} Whether to return the dataset names before actual
download (default \code{TRUE})}

\item{verbose}{\code{logical(1)} Whether to show the dataset currently being
(down)loaded (default \code{TRUE})}

\item{...}{Additional arguments passed on to the
\link[ExperimentHub]{ExperimentHub-class} constructor}
}
\value{
A multi-modality \code{MultiAssayExperiment}
}
\description{
Combine multiple single cell modalities into one using the input of the
individual functions.
}
\section{metadata}{

The metadata in the \code{MultiAssayExperiment} contains the original
function call used to generate the object (labeled as \code{call}),
a \code{call_map} which provides traceability of technology functions to
\code{DataType} prefixes, and lastly, R version information as \code{version}.
}

\examples{

SingleCellMultiModal(c("mouse_gastrulation", "pbmc_10x"),
    modes = list(c("acc*", "met*"), "rna"),
    version = c("2.0.0", "1.0.0"), dry.run = TRUE, verbose = TRUE
)

}
