% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CITEseq.R
\name{CITEseq}
\alias{CITEseq}
\title{CITEseq}
\usage{
CITEseq(
  DataType = c("cord_blood", "peripheral_blood"),
  modes = "*",
  version = "1.0.0",
  dry.run = TRUE,
  filtered = FALSE,
  verbose = TRUE,
  DataClass = c("MultiAssayExperiment", "SingleCellExperiment"),
  ...
)
}
\arguments{
\item{DataType}{\code{character(1)} indicating the identifier of the dataset to
retrieve.  (default "cord_blood")}

\item{modes}{\code{character()} The assay types or modes of data to obtain these
include scADT and scRNA-seq data by default.}

\item{version}{\code{character(1)} Either version '1.0.0' depending on
data version required.}

\item{dry.run}{\code{logical(1)} Whether to return the dataset names before actual
download (default \code{TRUE})}

\item{filtered}{\code{logical(1)} indicating if the returned dataset needs to
have filtered cells.
See Details for additional information about the filtering process.}

\item{verbose}{\code{logical(1)} Whether to show the dataset currently being
(down)loaded (default \code{TRUE})}

\item{DataClass}{either MultiAssayExperiment or SingleCellExperiment
data classes can be returned (default MultiAssayExperiment)}

\item{...}{Additional arguments passed on to the
\link[ExperimentHub]{ExperimentHub-class} constructor}
}
\value{
A single cell multi-modal
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
or informative \code{data.frame} when \code{dry.run} is \code{TRUE}. When \code{DataClass} is
\code{SingleCellExperiment} an object of this class is returned with an RNA
assay as main experiment and other assay(s) as \code{AltExp(s)}.
}
\description{
function assembles data on-the-fly from \code{ExperimentHub} to
provide a
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
container. Actually the \code{dataType} argument provides access to the
available datasets associated to the package.
}
\details{
CITEseq data are a combination of single cell transcriptomics and
about a hundread of cell surface proteins.
Available datasets are:
\itemize{
\item cord_blood: a dataset of single cells of cord blood as
provided in Stoeckius et al. (2017).
\itemize{
\item scRNA_Counts - Stoeckius scRNA-seq gene count matrix
\item scADT - Stoeckius antibody-derived tags (ADT) data
}
\item peripheral_blood: a dataset of single cells of peripheral
blood as provided in Mimitou et al. (2019). We provide two different
conditions controls (CTRL) and Cutaneous T-cell Limphoma (CTCL). Just build
appropriate \code{modes} regex for subselecting the dataset modes.
\itemize{
\item scRNA - Mimitou scRNA-seq gene count matrix
\item scADT - Mimitou antibody-derived tags (ADT) data
\item scHTO - Mimitou Hashtag Oligo (HTO) data
\item TCRab - Mimitou T-cell Receptors (TCR) alpha and beta
available through the object metadata.
\item TCRgd - Mimitou T-cell Receptors (TCR) gamma and delta
available through the object metadata.
}
}

If \code{filtered} parameter is \code{FALSE} (default), the \code{colData} of the returned
object contains multiple columns of \code{logicals} indicating the cells to be
discarded.
In case \code{filtered} is \code{TRUE}, the \code{discard} column is used to filer the
cells.
Column \code{adt.discard} indicates the cells to be discarded computed on the ADT
assay.
Column \code{mito.discard} indicates the cells to be discarded computed on the
RNA assay and mitocondrial genes.
Column \code{discard} combines the previous columns with an \code{OR} operator.
Note that for the \code{peripheral_blood} dataset these three columns are
computed and returned separately for the \code{CTCL} and \code{CTRL} conditions.
In this case the additional \code{discard} column combines the \code{discard.CTCL} and
\code{discard.CTRL} columns with an \code{OR} operator.
Cell filtering has been computed for \code{cord_blood} and \code{peripheral_blood}
datasets following section 12.3 of the Advanced Single-Cell Analysis with
Bioconductor book.
Executed code can be retrieved in the CITEseq_filtering.R script of this
package.
}
\examples{

mae <- CITEseq(DataType="cord_blood", dry.run=FALSE)
experiments(mae)
}
\references{
Stoeckius et al. (2017), Mimitou et al. (2019)
}
\author{
Dario Righelli
}
