% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dms_heatmap.R
\name{plot_dms_heatmap}
\alias{plot_dms_heatmap}
\title{Visualize DMS Scores Along a Protein}
\usage{
plot_dms_heatmap(
  assay_name,
  dms_data,
  start_pos = NULL,
  end_pos = NULL,
  exact_coord = FALSE,
  cluster_rows = FALSE,
  cluster_columns = FALSE,
  color_scheme,
  ...
)
}
\arguments{
\item{assay_name}{\code{character()} a valid DMS assay name. For the full list of
available assays, run \code{names()} on the list object loaded with
\code{ProteinGymR::dms_substitutions()}. Alternatively, the name of a
user-defined DMS assay.}

\item{dms_data}{\code{list()} object of DMS assays loaded with
\code{ProteinGymR::dms_substitutions()} if not specified by user.
Alternatively, a user-defined list of DMS assays with names corresponding
to \code{assay_name} param.}

\item{start_pos}{\code{integer()} first amino acid position to plot. If missing,
default start is at the first position along the protein where DMS scores
are available.}

\item{end_pos}{\code{integer()} last amino acid position to plot. If missing,
default end is at the last position along the protein where DMS scores
are available.}

\item{exact_coord}{\code{logical()} TRUE will plot the precise \code{start_pos}
and \code{end_pos} coordinates defined. By default, \code{exact_coord} is set to
FALSE, plotting only amino acid positions with available data in the
chosen assay.}

\item{cluster_rows}{\code{logical()} defaults to FALSE. See argument details in
\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap}.}

\item{cluster_columns}{\code{logical()} defaults to FALSE. See argument details in
\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap}.}

\item{color_scheme}{\code{character()} defaults to blue, white, and red to
represent positive, neutral, negative scores. Set argument equal to "EVE"
to use the color scheme consistent with the popEVE portal.}

\item{...}{additional arguments passed to internal plotting functions.}
}
\value{
Returns a \link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap} plot of DMS scores for each
position along a protein in a chosen DMS assay. The x-axis shows amino
acid positions where a DMS mutation exist, and the y-axis represents
possible amino acid residues, ordered by default based on the
physiochemical groupings. Higher and lower DMS scores indicate a more
positive or negative fitness effect after the mutation, respectively.
}
\description{
\code{plot_dms_heatmap()} plots DMS scores for amino acid
substitutions along a protein in a defined DMS assay.
}
\details{
For \code{plot_dms_heatmap()},
\code{dms_data} must be a \code{list()} object with set names for each assay
element matching \code{assay_name} parameter.

Each assay in the \code{dms_data()} must include the following columns:
\itemize{
\item \code{mutant}: Mutant identifier string matching.
Specifically, the set of substitutions to apply on the reference sequence
to obtain the mutated sequence (e.g., A1P:D2N implies the amino acid 'A'
at position 1 should be replaced by 'P', and 'D' at position 2 should be
replaced by 'N').
\item \code{DMS_score}: Experimental measurement in the DMS assay.
Higher values indicate higher fitness of the mutated protein.
}
}
\examples{

dms_data <- dms_substitutions()

plot_dms_heatmap(assay_name = "A0A192B1T2_9HIV1_Haddox_2018", 
    start_pos = 10, 
    end_pos = 80)
    
plot_dms_heatmap(assay_name = "A0A192B1T2_9HIV1_Haddox_2018", 
    start_pos = 10, 
    end_pos = 80, 
    exact_coord = TRUE,
    color_scheme = "EVE")
    
plot_dms_heatmap(assay_name = "A0A192B1T2_9HIV1_Haddox_2018", 
    start_pos = 50, 
    end_pos = 100, 
    cluster_rows = TRUE)

}
