/*
 * Decompiled with CFR 0.152.
 */
package slib.utils.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import slib.utils.ex.SLIB_Ex_Critic;

public class MatrixDynamic<N extends Number> {
    HashMap<Object, Integer> columnIndex;
    HashMap<Object, Integer> rowIndex;
    ArrayList<ArrayList<N>> matrix;

    public MatrixDynamic(Set<Object> columResources, Set<Object> rowResources) {
        this.columnIndex = new HashMap(columResources.size());
        this.rowIndex = new HashMap(this.rowIndex.size());
        this.matrix = new ArrayList(columResources.size());
        int id = 0;
        for (Object rc : columResources) {
            this.columnIndex.put(rc, id);
            ArrayList<Object> column = new ArrayList<Object>(rowResources.size());
            for (int i = 0; i < rowResources.size(); ++i) {
                column.add(null);
            }
            this.matrix.add(column);
            ++id;
        }
        id = 0;
        for (Object rc : rowResources) {
            this.rowIndex.put(rc, id);
            ++id;
        }
    }

    public List<N> getColumn(Object r) {
        return this.matrix.get(this.columnIndex.get(r));
    }

    public List<N> getRow(Object r) {
        if (!this.rowIndex.keySet().contains(r)) {
            return null;
        }
        ArrayList<N> row = new ArrayList<N>(this.columnIndex.keySet().size());
        for (Object c : this.columnIndex.keySet()) {
            row.add(this.getValue(c, r));
        }
        return row;
    }

    public N getValue(Object colResource, Object rowResource) {
        return (N)((Number)this.matrix.get(this.columnIndex.get(colResource)).get(this.rowIndex.get(rowResource)));
    }

    public void setValue(Object colResource, Object rowResource, N value) {
        this.matrix.get(this.columnIndex.get(colResource)).set(this.rowIndex.get(rowResource), value);
    }

    public boolean isInRowIndex(Object r) {
        return this.rowIndex.keySet().contains(r);
    }

    public boolean isInColumnIndex(Object r) {
        return this.columnIndex.keySet().contains(r);
    }

    public boolean isInIndexed(Object r) {
        return this.isInRowIndex(r) || this.isInColumnIndex(r);
    }

    public int getNbColumns() {
        return this.columnIndex.size();
    }

    public int getNbRows() {
        return this.rowIndex.size();
    }

    public void addColumn(Object r) throws SLIB_Ex_Critic {
        if (this.columnIndex.containsKey(r)) {
            throw new SLIB_Ex_Critic("Column " + r + "already exists");
        }
        int id = this.columnIndex.size() + 1;
        this.columnIndex.put(r, id);
        ArrayList<Object> column = new ArrayList<Object>(this.rowIndex.size());
        for (int i = 0; i < this.rowIndex.size(); ++i) {
            column.add(null);
        }
        this.matrix.add(column);
    }

    public void addRow(Object r) throws SLIB_Ex_Critic {
        if (this.rowIndex.containsKey(r)) {
            throw new SLIB_Ex_Critic("Row " + r + "already exists");
        }
        int id = this.rowIndex.size() + 1;
        this.rowIndex.put(r, id);
        for (int i = 0; i < this.columnIndex.size(); ++i) {
            this.matrix.get(i).add(null);
        }
    }

    public boolean isSquare() {
        return this.columnIndex.size() == this.rowIndex.size();
    }
}

