/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.ic.topo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.metrics.ic.topo.ICtopo;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.utils.LogBasedMetric;
import slib.sml.sm.core.utils.MathSML;
import slib.utils.ex.SLIB_Ex_Critic;

public class ICi_depth_max_nonlinear
extends LogBasedMetric
implements ICtopo {
    public Map<URI, Double> compute(Map<URI, Integer> alldepths) throws SLIB_Ex_Critic {
        HashMap<URI, Double> results = new HashMap<URI, Double>();
        double max_depth = Collections.max(alldepths.values()) + 1;
        Double logbase = this.getLogBase();
        if (logbase == null) {
            logbase = 2.0;
        }
        double den = MathSML.log(max_depth, logbase);
        for (URI v : alldepths.keySet()) {
            int depth = alldepths.get(v);
            double cur_ic = MathSML.log((double)depth + 1.0, logbase) / den;
            results.put(v, cur_ic);
        }
        return results;
    }

    @Override
    public Map<URI, Double> compute(IC_Conf_Topo conf, SM_Engine manager) throws SLIB_Ex_Critic {
        this.setLogBase(conf);
        return this.compute(manager.getMaxDepths());
    }
}

