/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.node_based;

import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_DAG_node_abstract;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class Sim_pairwise_DAG_node_Lin_1998
extends Sim_DAG_node_abstract {
    private static boolean PREVENT_INCOHERENCES = true;
    public static final boolean IS_SYMMETRIC = true;

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        double ic_a = c.getIC(conf.getICconf(), a);
        double ic_b = c.getIC(conf.getICconf(), b);
        double ic_MICA = c.getIC_MICA(conf.getICconf(), a, b);
        return Sim_pairwise_DAG_node_Lin_1998.sim(ic_a, ic_b, ic_MICA);
    }

    public static double sim(double ic_a, double ic_b, double ic_mica) throws SLIB_Ex_Critic {
        double lin = 0.0;
        double den = ic_a + ic_b;
        if (PREVENT_INCOHERENCES && (ic_mica > ic_a && ic_mica - ic_a > 1.0E-5 || ic_mica > ic_b && ic_mica - ic_b > 1.0E-5)) {
            throw new SLIB_Ex_Critic("Cannot compute Lin considering ic MICA > ic C1 or ic c2, ic MICA set to " + ic_mica + " ic c1 " + ic_a + " ic c2 " + ic_b);
        }
        if (den != 0.0) {
            lin = 2.0 * ic_mica / den;
        }
        return lin;
    }

    public void setPreventIncoherency(boolean preventIncoherency) {
        PREVENT_INCOHERENCES = preventIncoherency;
    }

    @Override
    public Boolean isSymmetric() {
        return true;
    }
}

