/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public class SingletonIterator<E>
implements Iterator<E> {
    private final AtomicReference<E> value;

    public SingletonIterator(E value) {
        this.value = new AtomicReference<E>(value);
    }

    @Override
    public boolean hasNext() {
        return this.value.get() != null;
    }

    @Override
    public E next() {
        E result = this.value.getAndSet(null);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

