/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.config;

import org.openrdf.sail.Sail;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.memory.MemoryStore;
import org.openrdf.sail.memory.config.MemoryStoreConfig;

public class MemoryStoreFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:MemoryStore";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new MemoryStoreConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        MemoryStore memoryStore = new MemoryStore();
        if (config instanceof MemoryStoreConfig) {
            MemoryStoreConfig memConfig = (MemoryStoreConfig)config;
            memoryStore.setPersist(memConfig.getPersist());
            memoryStore.setSyncDelay(memConfig.getSyncDelay());
        }
        return memoryStore;
    }
}

