/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.config;

import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.config.RepositoryRegistry;

public class RepositoryImplConfigBase
implements RepositoryImplConfig {
    private String type;

    public RepositoryImplConfigBase() {
    }

    public RepositoryImplConfigBase(String type) {
        this();
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        if (this.type == null) {
            throw new RepositoryConfigException("No type specified for repository implementation");
        }
    }

    @Override
    public Resource export(Graph graph) {
        BNode implNode = graph.getValueFactory().createBNode();
        if (this.type != null) {
            graph.add(implNode, RepositoryConfigSchema.REPOSITORYTYPE, graph.getValueFactory().createLiteral(this.type), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        try {
            Literal typeLit = GraphUtil.getOptionalObjectLiteral(graph, implNode, RepositoryConfigSchema.REPOSITORYTYPE);
            if (typeLit != null) {
                this.setType(typeLit.getLabel());
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }

    public static RepositoryImplConfig create(Graph graph, Resource implNode) throws RepositoryConfigException {
        try {
            Literal typeLit = GraphUtil.getOptionalObjectLiteral(graph, implNode, RepositoryConfigSchema.REPOSITORYTYPE);
            if (typeLit != null) {
                RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get(typeLit.getLabel());
                if (factory == null) {
                    throw new RepositoryConfigException("Unsupported repository type: " + typeLit.getLabel());
                }
                RepositoryImplConfig implConfig = factory.getConfig();
                implConfig.parse(graph, implNode);
                return implConfig;
            }
            return null;
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

