% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose_GSx7cTerm}
\alias{compose_GSx7cTerm}
\title{Compose a FlyCode GSx7cTerm Amino Acid Sequence}
\usage{
compose_GSx7cTerm(pool = c(rep("A", 18), rep("S", 6), rep("T", 12),
  rep("N", 1), rep("Q", 1), rep("D", 11), rep("E", 11), rep("V", 12),
  rep("L", 2), rep("F", 1), rep("Y", 4), rep("W", 1), rep("G", 8), rep("P",
  12)), cTerm = c("WR", "WLTVR", "WQEGGR", "WQSR", "WLR"))
}
\arguments{
\item{pool}{a vector of amino acids.}

\item{cTerm}{a vector of a sequence suffix.}
}
\value{
a amino acid sequence, e.g., GSAPTTVFGWLTVR.
}
\description{
composes, out of an as input given amino acid distribution,
a randomly sampled amino acid sequence. \code{\link{compose_GPGx8cTerm}},
\code{\link{compose_GSx7cTerm}}, and \code{\link{compose_GPx10R}} belong to
three groups composing different flycode (peptide) construction.
The construction is given in the function name. For example, GPGx8cTerm,
composes a flycode having as prefix GPG followed by eight (x8) amino acids
followed by a cTerm sequence. The different construction will have different
detectability properties as mass range and hydrophobicity values.
}
\examples{

 sample.size <- 100
 #
 ## Compose a GSXXXXXXX(WR|WLTVR|WQGGER|WQSR|WLR) peptide
 set.seed(2)
 FC.GSx7cTerm <- replicate(sample.size, compose_GSx7cTerm())
 ## Some Sanity Checks
 table(FC.GSx7cTerm)
 stopifnot(length(FC.GSx7cTerm) == 100)
 FC.PATTERN <- "^GS[ASTNQDEFVLYWGP]{7}(WR|WLTVR|WQEGGR|WLR|WQSR)$"
 stopifnot(
   length(FC.GSx7cTerm[grepl(FC.PATTERN, FC.GSx7cTerm)])
     == sample.size)

}
\author{
Christian Panse <cp@fgcz.ethz.ch> 2015
}
