% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RASampleMetadata.R
\docType{data}
\name{RASampleMetadata}
\alias{RASampleMetadata}
\title{Sample metadata from the Argelaguet et al. multiome atlas}
\format{
A data frame containing information for each 10x sample
of the embryo atlas.
This object contains:
\describe{
\item{\code{sample}:}{Integer, 10x sample index.}
\item{\code{sample_name}:}{Character, sample name provided by authors.}
\item{\code{stage}:}{Character, developmental stage from which sample was generated.}
\item{\code{ncells}:}{Integer, number of cells (post-QC) per sample.}
\item{\code{genotype}:}{Character, T_KO if brachyury knockout sample, otherwise WT.}
}
}
\usage{
RASampleMetadata
}
\description{
A data frame containing stage and genotype information for
the multiome atlas dataset.
}
\examples{
head(RASampleMetadata)

}
\references{
Pijuan-Sala B, Griffiths JA, Guibentif C et al. (2019).
A single-cell molecular map of mouse gastrulation and early organogenesis.
\emph{Nature} 566, 7745:490-495.
}
\keyword{datasets}
