#' Collection of public MERFISH datasets
#' 
#' @description MerfishData is an ExperimentHub package that serves publicly available
#' datasets obtained with Multiplexed Error-Robust Fluorescence in situ Hybridization
#' (MERFISH). MERFISH is a massively multiplexed single-molecule imaging technology
#' capable of simultaneously measuring the copy number and spatial distribution
#' of hundreds to tens of thousands of RNA species in individual cells. The scope
#' of the package is to provide MERFISH data for benchmarking and analysis.
#'
#' @name MerfishData-package
#' @aliases MerfishData-package MerfishData
#' @docType package
#' @author Ludwig Geistlinger <ludwig_geistlinger@@hms.harvard.edu>
#' @import EBImage
#' @import SpatialExperiment
#' @importFrom grDevices as.raster
#' @importFrom S4Vectors metadata metadata<-
#' @importFrom utils setTxtProgressBar txtProgressBar
#' @importFrom HDF5Array HDF5Array
NULL
