% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_summary_table.R
\name{get_summary_table}
\alias{get_summary_table}
\title{Create a table summarizing reads aggregated by grouping variables on a unit}
\usage{
get_summary_table(dat, group_vars = NULL)
}
\arguments{
\item{dat}{A \code{MultiAssayExperiment} object specially formatted as an
animalcules output.}

\item{group_vars}{A character string or character vector of covariates
found in \code{colData(dat)} to use in grouping counts. The variables
should be listed in order of desired grouping. Default is \code{NULL},
which does not rely on a grouping variable and instead produces statistics
for the entirety of the data.}
}
\value{
A \code{data.frame} of the grouping columns, mean_reads, sd_reads,
min_reads, max_reads and num_total.
}
\description{
This function takes a \code{MultiAssayExperiment} of microbial read counts
and aggregates them by one or more grouping vars within a unit.
}
\examples{
in_dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
out <- get_summary_table(in_dat, c("Group", "Subject"))
head(out)

}
