% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{distinctColors}
\alias{distinctColors}
\title{Generate a distinct palette for coloring different clusters.}
\usage{
distinctColors(
  n,
  hues = c("red", "cyan", "orange", "blue", "yellow", "purple", "green", "magenta"),
  saturation.range = c(0.7, 1),
  value.range = c(0.7, 1)
)
}
\arguments{
\item{n}{an integer describing the number of colors to generate. Required.}

\item{hues}{a vector of character strings indicating the R colors available
from the \code{colors()} function. These will be used as the base colors for
the clustering scheme. Different saturations and values (i.e. darkness)
will be generated for each hue. Default is \code{c("red", "cyan", "orange",
"blue", "yellow", "purple", "green", "magenta")}}

\item{saturation.range}{a numeric vector of length 2 with values between 0
and 1 giving the range of saturation. The default is \code{c(0.25, 1)}.}

\item{value.range}{a numeric vector of length 2 with values between 0 and 1
giving the range of values. The default is \code{c(0.5, 1)}.}
}
\value{
A vector of distinct colors that have been converted to HEX from
HSV.
}
\description{
Create a distinct palette for coloring different heatmap clusters. The
function returns colors for input into \code{ComplexHeatmap:Heatmap()}.
The "grDevices" package is required to use this function.
}
\examples{

distinctColors(10)

}
