# JohnsonKinaseData

`JohnsonKinaseData` is an
R/[ExperimentHub](https://bioconductor.org/packages/release/bioc/html/ExperimentHub.html)
package providing access to position specific weight matrices (PWMs) for 303 
human serine/threonine and 93 tyrosine kinases originally published in 
Johnson et al. and Yaron-Barir et al.

The package includes functionality to match PWMs against user-provided 
phosphosites and to convert PWM scores into percentile ranks using background
score distributions.

All data records are available under
[https://zenodo.org/records/10628874](https://zenodo.org/records/10628874) and 
[https://zenodo.org/records/13785426](https://zenodo.org/records/13785426)
according to open data standards and licenses under the [Creative
Commons Attribution 4.0 International license (CC-BY
4.0)](https://creativecommons.org/licenses/by/4.0/).

## References

Johnson, J.L., Yaron, T.M., Huntsman, E.M. et al. An atlas of
substrate specificities for the human serine/threonine kinome. Nature
613, 759–766 (2023). [https://doi.org/10.1038/s41586-022-05575-3](https://doi.org/10.1038/s41586-022-05575-3)

Yaron-Barir, T.M., Joughin, B.A., Huntsman, E.M. et al. The intrinsic
substrate specificity of the human tyrosine kinome. Nature 629, 1174–1181
(2024). [https://doi.org/10.1038/s41586-024-07407-y](https://doi.org/10.1038/s41586-024-07407-y)

