% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateAnnotation.R
\name{updateAnnotation}
\alias{updateAnnotation}
\title{Update cell type annotation}
\usage{
updateAnnotation(sce, refAnnotation = "20220215", newAnnotation = "20220619")
}
\arguments{
\item{sce}{A SingleCellExperiment object obtained using HCATonsilData
function.}

\item{refAnnotation}{string specifying the date of the annotation to use as
reference.}

\item{newAnnotation}{string specifying the suffix to add to the new column
(annotation_*).}
}
\value{
A SingleCellExperiment object with additional an additional column
(annotation_*) that contains more annotations.
}
\description{
Annotations are dynamic by nature. As more experts look into the data and
newer literature comes out, we expect annotations to be refined over time.
We have accommodated this by allowing us and users to add new annotations
to the SingleCellExperiment objects. If you want to propose a new
annotation based on your experience or new evidence, please open an issue
at https://github.com/massonix/HCATonsilData/issues.
}
\examples{
# update the annotation from preprint (version 1.0) to publication (version 2.0)
\dontrun{
sce <- updateAnnotation(
  sce,
  refAnnotation = "20220619",
  newAnnotation = "20230508"
)
}
}
