% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_performance.R
\name{plot_performance}
\alias{plot_performance}
\title{Plot performance of clustering methods}
\usage{
plot_performance(res, method_colors = NULL)
}
\arguments{
\item{res}{A data.frame with clustering results.}

\item{method_colors}{A named vector with colors to use for the different
clustering methods. Can be NULL, in which case colors are chosen
automatically.}
}
\value{
A named list of \code{ggplot2} objects
}
\description{
Generate various plots of the agreement between each clustering and the true
partitioning of the cells, quantified by the adjusted Rand index (ARI).
}
\examples{
res <- clustering_summary_filteredExpr10_Koh_v1()
plots <- plot_performance(res)

}
\author{
Angelo Duo, Charlotte Soneson
}
