% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconvolution.R
\name{cmi_deconvolution2}
\alias{cmi_deconvolution2}
\title{Reference-based cell type deconvolution (allowing one unknown component)}
\usage{
cmi_deconvolution2(ref, q, trim = FALSE, ...)
}
\arguments{
\item{ref}{reference methylation}

\item{q}{target measurement: length(q) == nrow(ref)}

\item{trim}{to trim query input beta values.
this relieves unclean background subtraction}

\item{...}{extra parameters to .optimizeFrac}
}
\value{
a list of fraction, min error and unknown component methylation state
}
\description{
This is a reference-based cell composition estimation. The function takes a
reference methylation status matrix (rows for probes and columns for cell
types) and a query beta value measurement.
}
\details{
The length of the target beta values should be the same as
the number of rows of the reference Matrix. The method assumes one unknown
component. It outputs a list containing the estimated cell fraction, the
error of optimization and methylation status of the unknown component.
}
\examples{

ref = cbind(
  CD4 = c(1,1,1,0,1,0),
  CD19 = c(0,0,1,1,0,1),
  CD14 = c(1,1,1,1,0,1))
rownames(ref) = paste0("cg",1:6)
trueFrac = runif(4)
trueFrac = trueFrac / sum(trueFrac)
ref_unk = sample(c(0,1), nrow(ref), replace=TRUE)
q = cbind(ref_unk, ref) \%*\% trueFrac
trueFrac
res = cmi_deconvolution2(ref, q)
res$frac

}
