% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppiTables.R
\name{getPPIbyIDs}
\alias{getPPIbyIDs}
\title{Extract the PPIs for my list of genes defined by GeneID}
\usage{
getPPIbyIDs(ids, type = c("limited", "induced"))
}
\arguments{
\item{ids}{Gene IDs}

\item{type}{type of the PPI network should be either \code{induced} (for
all the PPIs for specific genes, including external genes) or
\code{limited} (for PPIs between the genes specified in the query).
Type could be shortened to recognizable minimum like 'ind'
or 'lim'.}
}
\value{
data.frame with interactors internal GeneID in columns A and B
}
\description{
Get Protein-Protein interactions (PPIs) for the set of internal GeneIDs.
Function lookups for PPIs for specific GeneID and returns either “induced”
(all interaction for this GeneID) or “limited” (only interactions between
GeneIDs specified in the query) table of A and B interacting genes, where
A and B are respective GeneIDs.
}
\examples{
t <- getPPIbyIDs(c(48, 585, 710), type = "limited") # (16 rows)
t <- getPPIbyIDs(c(48, 585, 710), type = "induced") # 306 rows
}
\seealso{
\code{\link[=getPPIbyName]{getPPIbyName()}} and
\code{\link[=getPPIbyEntrez]{getPPIbyEntrez()}} to get
PPI \code{data.frame},
\code{\link[=getIGraphFromPPI]{getIGraphFromPPI()}} to get igraph
representation of the PPI \code{data.frame} and
\code{\link[=getTableFromPPI]{getTableFromPPI()}} to
get interpretable
table representation of the PPI \code{data.frame}.

Other {PPI functions}: 
\code{\link{getIGraphFromPPI}()},
\code{\link{getPPIbyEntrez}()},
\code{\link{getPPIbyIDs4BrainRegion}()},
\code{\link{getPPIbyIDs4Compartment}()},
\code{\link{getPPIbyName}()},
\code{\link{getTableFromPPI}()}
}
\concept{{PPI functions}}
