% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compartments.R
\name{getAllGenes4Compartment}
\alias{getAllGenes4Compartment}
\title{Extract all genes found in compartment}
\usage{
getAllGenes4Compartment(compartmentID)
}
\arguments{
\item{compartmentID}{ID for specific compartment}
}
\value{
data.frame described in \code{\link[=getGenesByID]{getGenesByID()}}
}
\description{
Get all genes annotated for specific compartment. Function
returns main information like internal Gene IDs, MGI ID,
Human Entrez ID, Human Gene Name, Mouse Entrez ID,
Mouse Gene Name, Rat Entrez ID, Rat Gene Name.
}
\examples{
G <- getAllGenes4Compartment(compartmentID = 1) # 5560 rows
}
\seealso{
Other {Gene functions}: 
\code{\link{findGeneByCompartmentPaperCnt}()},
\code{\link{findGeneByPaperCnt}()},
\code{\link{findGeneByPapers}()},
\code{\link{findGenesByEntrez}()},
\code{\link{findGenesByName}()},
\code{\link{getGenes4Compartment}()},
\code{\link{getGenesByID}()}

Other {Compartment functions}: 
\code{\link{getCompartments}()},
\code{\link{getGenes4Compartment}()},
\code{\link{getPPIbyIDs4Compartment}()}
}
\concept{{Compartment functions}}
\concept{{Gene functions}}
