datacache <- new.env(hash=TRUE, parent=emptyenv())

org.EcSakai.eg <- function() showQCData("org.EcSakai.eg", datacache)
org.EcSakai.eg_dbconn <- function() dbconn(datacache)
org.EcSakai.eg_dbfile <- function() dbfile(datacache)
org.EcSakai.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.EcSakai.eg_dbInfo <- function() dbInfo(datacache)

org.EcSakai.egORGANISM <- "Escherichia coli"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.EcSakai.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("ECOLI_DB", "org.EcSakai.eg", "E coli", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.EcSakai.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.EcSakai.eg_dbconn())
}

