GRASP2 <- local({
    d <- NULL
    function() {
        if (is.null(d)) {
            con <- AnnotationHub::AnnotationHub()[["AH21414"]]
            initExtension(con)
            d <<- src_dbi(con)
        }
        d
    }
})

.onAttach = function(libname, pkgname) {
    txt <- "
      grasp2db: see http://apps.nhlbi.nih.gov/Grasp/Overview.aspx for
        details
    
      Users please cite: 
        Eicher JD, Landowski C, Stackhouse B, Sloan A, Chen W, Jensen N,
        Lien J-P, Leslie R, Johnson AD (2014) GRASP v 2.0: an update to
        the genome-wide repository of associations between SNPs and
        phenotypes.  Nucl Acids Res, published online Nov 26, 2014 PMID
        25428361
    
      Terms of Use: http://apps.nhlbi.nih.gov/Grasp/Terms.aspx
    
      Medical disclaimer: http://apps.nhlbi.nih.gov/Grasp/Overview.aspx

      Use tbl(GRASP2(), 'variant') %>% [select()/filter()/...] to execute
      queries on recorded variants"
  
    packageStartupMessage(paste(strwrap(txt, exdent=2), collapse="\n"))
}
