% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{TENET_consensus_promoter_regions}
\alias{TENET_consensus_promoter_regions}
\title{TENET consensus promoter regions}
\source{
{
\url{https://egg2.wustl.edu/roadmap/web_portal/chr_state_learning.html}
}
}
\usage{
TENET_consensus_promoter_regions(metadata = FALSE)
}
\arguments{
\item{metadata}{If TRUE, retrieve the AnnotationHub metadata instead of the
object itself. Defaults to FALSE.}
}
\value{
A GRanges object with 361,315 ranges and no metadata.
}
\description{
A composite GRanges object containing regions of putative
promoter elements from a variety of sources, primarily for use in the TENET
Bioconductor package. This dataset is composed of regions flanking
transcription start sites as annotated by the Roadmap Epigenomics ChromHMM
expanded 18-state model based on 98 reference epigenomes, lifted over to the
hg38 genome (the following 4 states represent regions flanking transcription
start sites: 1: Active TSS, 2: Flanking TSS, 3: Flanking TSS Upstream, and
4: Flanking TSS Downstream). For additional information on component
datasets, see the manifest file hosted at
\url{https://github.com/rhielab/TENET.AnnotationHub/blob/devel/data-raw/TENET_consensus_datasets_manifest.tsv}.
\strong{Citation:} Roadmap Epigenomics Consortium;
Kundaje A, Meuleman W, Ernst J, et al. Integrative analysis of 111 reference
human epigenomes. Nature. 2015 Feb 19;518(7539):317-30. doi:
10.1038/nature14248. PMID: 25693563; PMCID: PMC4530010.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
TENET_consensus_promoter_regions()
\dontshow{\}) # examplesIf}
}
