% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/zinbwave.R
\name{zinbwave}
\alias{zinbwave}
\alias{zinbwave,SummarizedExperiment-method}
\title{Perform dimensionality reduction using a ZINB regression model with
gene and cell-level covariates.}
\usage{
zinbwave(Y, ...)

\S4method{zinbwave}{SummarizedExperiment}(
  Y,
  X,
  V,
  K = 2,
  fitted_model,
  which_assay,
  which_genes,
  commondispersion = TRUE,
  zeroinflation = TRUE,
  verbose = FALSE,
  nb.repeat.initialize = 2,
  maxiter.optimize = 25,
  stop.epsilon.optimize = 1e-04,
  BPPARAM = BiocParallel::bpparam(),
  normalizedValues = FALSE,
  residuals = FALSE,
  imputedValues = FALSE,
  observationalWeights = FALSE,
  ...
)
}
\arguments{
\item{Y}{The data (genes in rows, samples in columns). Currently implemented
only for \code{SummarizedExperiment}.}

\item{...}{Additional parameters to describe the model, see
\code{\link{zinbModel}}.}

\item{X}{The design matrix containing sample-level covariates, one sample per
row. If missing, X will contain only an intercept. If Y is a
SummarizedExperiment object, X can be a formula using the variables in the
colData slot of Y.}

\item{V}{The design matrix containing gene-level covariates, one gene
per row. If missing, V will contain only an intercept. If Y is a
SummarizedExperiment object, V can be a formula using the variables in the
rowData slot of Y.}

\item{K}{integer. Number of latent factors. Specify \code{K = 0} if only
computing observational weights.}

\item{fitted_model}{a \code{\link{ZinbModel}} object.}

\item{which_assay}{numeric or character. Which assay of Y to use. If missing,
if `assayNames(Y)` contains "counts" then that is used. Otherwise, the
first assay is used.}

\item{which_genes}{character. Which genes to use to estimate W (see details).
Ignored if \code{fitted_model} is provided.}

\item{commondispersion}{Whether or not a single dispersion for all features
is estimated (default TRUE).}

\item{zeroinflation}{Whether or not a ZINB model should be fitted. If FALSE,
a negative binomial model is fitted instead.}

\item{verbose}{Print helpful messages.}

\item{nb.repeat.initialize}{Number of iterations for the initialization of
beta_mu and gamma_mu.}

\item{maxiter.optimize}{maximum number of iterations for the optimization
step (default 25).}

\item{stop.epsilon.optimize}{stopping criterion in the optimization step,
when the relative gain in likelihood is below epsilon (default 0.0001).}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{\link[BiocParallel]{bpparam}} for details.}

\item{normalizedValues}{indicates wether or not you want to compute
normalized values for the counts after adjusting for gene and cell-level
covariates.}

\item{residuals}{indicates wether or not you want to compute the residuals
of the ZINB model. Deviance residuals are computed.}

\item{imputedValues}{indicates wether or not you want to compute the imputed
counts of the ZINB model.}

\item{observationalWeights}{indicates whether to compute the observational
weights for differential expression (see vignette).}
}
\value{
An object of class \code{SingleCellExperiment}; the dimensionality
  reduced matrix is stored in the \code{reducedDims} slot and optionally
  normalized values and residuals are added in the list of assays.
}
\description{
Given an object with the data, it performs dimensionality reduction using
a ZINB regression model with gene and cell-level covariates.
}
\details{
For visualization (heatmaps, ...), please use the normalized values.
It corresponds to the deviance residuals when the \code{W} is not included
in the model but the gene and cell-level covariates are. As a results, when
\code{W} is not included in the model, the deviance residuals should capture
the biology. Note that we do not recommend to use the normalized values for
any downstream analysis (such as clustering, or differential expression), but
only for visualization.

If one has already fitted a model using \code{\link{ZinbModel}},
the object containing such model can be used as input of \code{zinbwave} to
save the resulting W into a \code{SummarizedExperiment} and optionally
compute residuals and normalized values, without the need for re-fitting the
model.

By default \code{zinbwave} uses all genes to estimate \code{W}.
  However, we recommend to use the top 1,000 most variable genes for this
  step. In general, a user can specify any custom set of genes to be used to
  estimate \code{W}, by specifying either a vector of gene names, or a single
  character string corresponding to a column of the \code{rowData}.

Note that if both \code{which_genes} is specified and at least one
  among \code{observationalWeights}, \code{imputedValues}, \code{residuals},
  and \code{normalizedValues} is \code{TRUE}, the model needs to be fit
  twice.
}
\section{Methods (by class)}{
\itemize{
\item \code{zinbwave(SummarizedExperiment)}: Y is a
\code{\link[SummarizedExperiment]{SummarizedExperiment}}.

}}
\examples{
se <- SingleCellExperiment(assays = list(counts = matrix(rpois(60, lambda=5),
                                                         nrow=10, ncol=6)),
                           colData = data.frame(bio = gl(2, 3)))

m <- zinbwave(se, X="~bio", BPPARAM=BiocParallel::SerialParam())
}
