% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detest.R
\name{independentFiltering}
\alias{independentFiltering}
\title{Perform independent filtering in differential expression analysis.}
\usage{
independentFiltering(object, filter, objectType = c("edgeR", "limma"))
}
\arguments{
\item{object}{Either a \code{\link[edgeR]{DGELRT-class}} object or
a \code{\link{data.frame}} with differential expression results.}

\item{filter}{The characteristic to use for filtering, usually a
measure of normalized mean expression for the features.}

\item{objectType}{Either \code{"edgeR"} or \code{"limma"}. If
\code{"edgeR"}, it is assumed that \code{object} is of class
\code{\link[edgeR]{DGELRT-class}}, the output of
\code{\link[edgeR]{glmLRT}}. If \code{"limma"}, it is assumed that
\code{object} is a \code{\link{data.frame}} and the output of a
limma-voom analysis.}
}
\description{
This function uses the \code{DESeq2} independent filtering method
to increase detection power in high throughput gene expression
studies.
}
\references{
Michael I Love, Wolfgang Huber, and Simon Anders.
Moderated estimation of fold change and dispersion for RNA-seq data
with DESeq2. Genome Biology, 15(12):550, dec 2014.
}
\seealso{
\code{\link[DESeq2]{results}}
}
\author{
Koen Van den Berge
}
