% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readH5AD}
\alias{readH5AD}
\title{Read H5AD}
\usage{
readH5AD(
  file,
  X_name = NULL,
  use_hdf5 = FALSE,
  reader = c("python", "R"),
  version = NULL,
  verbose = NULL,
  ...
)
}
\arguments{
\item{file}{String containing a path to a \code{.h5ad} file.}

\item{X_name}{Name used when saving \code{X} as an assay. If \code{NULL} looks for an
\code{X_name} value in \code{uns}, otherwise uses \code{"X"}.}

\item{use_hdf5}{Logical scalar indicating whether assays should be
loaded as HDF5-based matrices from the \strong{HDF5Array} package.}

\item{reader}{Which HDF5 reader to use. Either \code{"python"} for reading with
the \strong{anndata} Python package via \strong{reticulate} or \code{"R"} for
\strong{zellkonverter}'s native R reader.}

\item{version}{A string giving the version of the \strong{anndata} Python library
to use. Allowed values are available in \code{.AnnDataVersions}. By default the
latest version is used.}

\item{verbose}{Logical scalar indicating whether to print progress messages.
If \code{NULL} uses \code{getOption("zellkonverter.verbose")}.}

\item{...}{
  Arguments passed on to \code{\link[=AnnData2SCE]{AnnData2SCE}}
  \describe{
    \item{\code{layers,uns,var,obs,varm,obsm,varp,obsp,raw}}{Arguments specifying how
these slots are converted. If \code{TRUE} everything in that slot is converted, if
\code{FALSE} nothing is converted and if a character vector only those items or
columns are converted.}
    \item{\code{skip_assays}}{Logical scalar indicating whether to skip conversion of
any assays in \code{sce} or \code{adata}, replacing them with empty sparse matrices
instead.}
  }}
}
\value{
A \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} object is returned.
}
\description{
Reads a H5AD file and returns a \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment}
object.
}
\details{
Setting \code{use_hdf5 = TRUE} allows for very large datasets to be efficiently
represented on machines with little memory. However, this comes at the cost
of access speed as data needs to be fetched from the HDF5 file upon request.

Setting \code{reader = "R"} will use an experimental native R reader instead of
reading the file into Python and converting the result. This avoids the need
for a Python environment and some of the issues with conversion but is still
under development and is likely to return slightly different output.

See \link{AnnData-Environment} for more details on \strong{zellkonverter} Python
environments.
}
\examples{
library(SummarizedExperiment)

file <- system.file("extdata", "krumsiek11.h5ad", package = "zellkonverter")
sce <- readH5AD(file)
class(assay(sce))

sce2 <- readH5AD(file, use_hdf5 = TRUE)
class(assay(sce2))

sce3 <- readH5AD(file, reader = "R")
}
\seealso{
\code{\link[=writeH5AD]{writeH5AD()}}, to write a \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment}
object to a H5AD file.

\code{\link[=AnnData2SCE]{AnnData2SCE()}}, for developers to convert existing AnnData instances to a
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment}.
}
\author{
Luke Zappia

Aaron Lun
}
