% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-imputation.R
\name{imputeRowMin}
\alias{imputeRowMin}
\title{Replace missing values with a proportion of the row minimum}
\usage{
imputeRowMin(x, min_fraction = 1/2)
}
\arguments{
\item{x}{\code{matrix} with abundances, rows being features/metabolites and
columns samples.}

\item{min_fraction}{\code{numeric(1)} with the fraction of the row minimum that
should be used to replace \code{NA} values in that row.}
}
\description{
\code{imputeRowMin} imputes missing values in \code{x} by replacing \code{NA}s in each row
with a proportion of the minimal value for that row (i.e.
\code{min_fraction * min(x[i, ])}).
}
\examples{

library(MSnbase)
library(faahKO)
data("faahko")

xset <- group(faahko)
mat <- groupval(xset, value = "into")

mat_imp <- imputeRowMin(mat)

head(mat)
head(mat_imp)

## Replace with 1/8 of the row mimimum
head(imputeRowMin(mat, min_fraction = 1/8))
}
\seealso{
\code{imputeLCMD} package for more left censored imputation functions.

Other imputation functions: 
\code{\link{imputeRowMinRand}()}
}
\author{
Johannes Rainer
}
\concept{imputation functions}
