% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-group-features.R
\name{groupFeatures-similar-rtime}
\alias{groupFeatures-similar-rtime}
\alias{groupFeatures,XcmsResult,SimilarRtimeParam-method}
\title{Compounding/feature grouping based on similar retention times}
\usage{
\S4method{groupFeatures}{XcmsResult,SimilarRtimeParam}(object, param, msLevel = 1L, ...)
}
\arguments{
\item{object}{\code{\link[=XcmsExperiment]{XcmsExperiment()}} or \code{\link[=XCMSnExp]{XCMSnExp()}} object containing also
correspondence results.}

\item{param}{\code{SimilarRtimeParam} object with the settings for the method. See
\code{\link[MsFeatures:groupFeatures-similar-rtime]{MsFeatures::SimilarRtimeParam()}} for details and options.}

\item{msLevel}{\code{integer(1)} defining the MS level on which the features
should be grouped.}

\item{...}{passed to the \code{groupFeatures()} function on numeric values.}
}
\value{
the input object with feature groups added (i.e. in column
\code{"feature_group"} of its \code{featureDefinitions} data frame.
}
\description{
Group features based on similar retention time. This method is supposed to be
used as an initial \emph{crude} grouping of features based on the median retention
time of all their chromatographic peaks. All features with a difference in
their retention time which is \code{<=} parameter \code{diffRt} of the parameter object
are grouped together. If a column \code{"feature_group"} is found in
\code{\link[=featureDefinitions]{featureDefinitions()}} this is further sub-grouped by this method.

See \code{\link[MsFeatures:groupFeatures-similar-rtime]{MsFeatures::SimilarRtimeParam()}} in \code{MsFeatures} for more details.
}
\examples{

library(MsFeatures)
library(MsExperiment)
## Load a test data set with detected peaks
faahko_sub <- loadXcmsData("faahko_sub2")

## Disable parallel processing for this example
register(SerialParam())

## Group chromatographic peaks across samples
xodg <- groupChromPeaks(faahko_sub, param = PeakDensityParam(sampleGroups = rep(1, 3)))

## Group features based on similar retention time (i.e. difference <= 2 seconds)
xodg_grp <- groupFeatures(xodg, param = SimilarRtimeParam(diffRt = 2))

## Feature grouping get added to the featureDefinitions in column "feature_group"
head(featureDefinitions(xodg_grp)$feature_group)

table(featureDefinitions(xodg_grp)$feature_group)
length(unique(featureDefinitions(xodg_grp)$feature_group))

## Using an alternative groupiing method that creates larger groups
xodg_grp <- groupFeatures(xodg,
    param = SimilarRtimeParam(diffRt = 2, groupFun = MsCoreUtils::group))

length(unique(featureDefinitions(xodg_grp)$feature_group))
}
\seealso{
Other feature grouping methods: 
\code{\link{groupFeatures-abundance-correlation}},
\code{\link{groupFeatures-eic-similarity}}
}
\author{
Johannes Rainer
}
\concept{feature grouping methods}
