% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSizeDistribution.R
\name{plotSizeDistribution}
\alias{plotSizeDistribution}
\title{Plot the distribution of cluster sizes}
\usage{
plotSizeDistribution( clusters, showCov = FALSE, ... )
}
\arguments{
\item{clusters}{GRanges object containing individual clusters as identified
by the \link{getClusters} function}

\item{showCov}{logical, if TRUE a scatter plot of average cluster coverage
vs. cluster size is shown along with a loess fit. Default is FALSE.}

\item{...}{Additional parameters to be passed to the \code{hist} function}
}
\value{
Called for its effect, returns a histogram.
}
\description{
Produce an histogram of cluster sizes
}
\examples{

require(BSgenome.Hsapiens.UCSC.hg19)

data( model, package = "wavClusteR" ) 

filename <- system.file( "extdata", "example.bam", package = "wavClusteR" )
example <- readSortedBam( filename = filename )
countTable <- getAllSub( example, minCov = 10, cores = 1 )
highConfSub <- getHighConfSub( countTable, supportStart = 0.2, supportEnd = 0.7, substitution = "TC" )
coverage <- coverage( example )
clusters <- getClusters( highConfSub = highConfSub, 
                         coverage = coverage, 
                         sortedBam = example, 
	                        threshold = 2 ) 

fclusters <- filterClusters( clusters = clusters, 
		             highConfSub = highConfSub, 
        		     coverage = coverage,
			     model = model, 
			     genome = Hsapiens, 
		             refBase = 'T', 
		             minWidth = 12 )
plotSizeDistribution(fclusters, breaks = 30, col = 'skyblue2')

}
\seealso{
\code{\link{getClusters}}
}
\author{
Federico Comoglio
}
\keyword{graphics}
\keyword{postprocessing}
