% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WassersteinTest.R
\name{.wassersteinTestSp}
\alias{.wassersteinTestSp}
\title{Semi-parametric test using the 2-Wasserstein distance to check for differential distributions}
\usage{
.wassersteinTestSp(x, y, permnum = 10000)
}
\arguments{
\item{x}{sample (vector) representing the distribution of
condition \eqn{A}}

\item{y}{sample (vector) representing the distribution of
condition \eqn{B}}

\item{permnum}{number of permutations used in the permutation testing
procedure}
}
\value{
A vector of 15, see Schefzik et al. (2020) for details:
\itemize{
\item d.wass: 2-Wasserstein distance between the two samples computed by
quantile approximation
\item d.wass^2: squared 2-Wasserstein distance between the two samples
computed by quantile approximation
\item d.comp^2: squared 2-Wasserstein distance between the two samples
computed by decomposition approximation
\item d.comp: 2-Wasserstein distance between the two samples computed by
decomposition approximation
\item location: location term in the decomposition of the squared
2-Wasserstein distance between the two samples
\item size: size term in the decomposition of the squared 2-Wasserstein
distance between the two samples
\item shape: shape term in the decomposition of the squared 2-Wasserstein
distance between the two samples
\item rho: correlation coefficient in the quantile-quantile plot
\item pval: p-value of the semi-parametric 2-Wasserstein distance-based
test
\item p.ad.gpd: in case the GPD fitting is performed: p-value of the
Anderson-Darling test to check whether the GPD actually fits the data well
(otherwise NA). 
\item N.exc: in case the GPD fitting is performed: number of exceedances
(starting with 250 and iteratively decreased by 10 if necessary) that are
required to obtain a good GPD fit, i.e. p-value of Anderson-Darling test
\eqn{\geq 0.05} (otherwise NA). 
\item perc.loc: fraction (in \%) of the location part with respect to the
overall squared 2-Wasserstein distance obtained by the decomposition
approximation
\item perc.size: fraction (in \%) of the size part with respect to the
overall squared 2-Wasserstein distance obtained by the decomposition
approximation
\item perc.shape: fraction (in \%) of the shape part with respect to the
overall squared 2-Wasserstein distance obtained by the decomposition
approximation
\item decomp.error: relative error between the squared 2-Wasserstein
distance obtained by the quantile approximation and the squared
2-Wasserstein distance obtained by the decomposition approximation
}
}
\description{
Two-sample test to check for differences between two distributions
using the 2-Wasserstein distance: Semi-parametric
implementation using a permutation test with a generalized Pareto
distribution (GPD) approximation to estimate small p-values accurately
}
\details{
This is the semi-parametric version of \code{wasserstein.test}, for the
asymptotic theory-based procedure see \code{.wassersteinTestAsy}.

Details concerning the permutation testing procedure with GPD
approximation to estimate small p-values accurately can be found in Schefzik
et al. (2020).
}
\references{
Schefzik, R., Flesch, J., and Goncalves, A. (2020). waddR: Using the 2-Wasserstein distance to identify differences between distributions in two-sample testing, with application to single-cell RNA-sequencing data.
}
